unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, AdvMenus, AdvToolBar, AdvToolBarStylers, StdCtrls,
  AdvOfficeTabSet, AdvOfficeTabSetStylers, AdvMenuStylers, AdvOfficeHint;

type
  TForm1 = class(TForm)
    AdvDockPanel1: TAdvDockPanel;
    AdvToolBar1: TAdvToolBar;
    AdvMainMenu1: TAdvMainMenu;
    Tasks1: TMenuItem;
    Window1: TMenuItem;
    AddChild: TMenuItem;
    Cascade1: TMenuItem;
    AdvToolBarOfficeStyler1: TAdvToolBarOfficeStyler;
    AdvMenuStyler1: TAdvMenuStyler;
    N1: TMenuItem;
    AdvOfficeTabSetOfficeStyler1: TAdvOfficeTabSetOfficeStyler;
    PopupMenu1: TPopupMenu;
    AdvOfficeMDITabSet1: TAdvOfficeMDITabSet;
    AdvMenuOfficeStyler1: TAdvMenuOfficeStyler;
    AdvPopupMenu1: TAdvPopupMenu;
    AdvOfficeHint1: TAdvOfficeHint;
    procedure AddChildClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    FChildCount: Integer;
    FChildCloseEvent: TCloseEvent;
    procedure ChildFormClose(Sender: TObject; var Action: TCloseAction);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses Unit2;

procedure TForm1.AddChildClick(Sender: TObject);
var
  rsChild: TForm2;
begin
  rsChild := TForm2.Create(self);
  AdvToolBar1.AddMDIChildMenu(rsChild);
  FChildCloseEvent := rsChild.OnClose;
  rsChild.OnClose := ChildFormClose;
  Inc(FChildCount);
  rsChild.Show;
  AdvOfficeMDITabSet1.AddTab(rsChild);
  with AdvOfficeMDITabSet1.AdvOfficeTabs[AdvOfficeMDITabSet1.AdvOfficeTabCount - 1] do
  begin
    OfficeHint.Title := rsChild.Caption;
    OfficeHint.Notes.Text := 'Some notes';
  end;

end;

procedure TForm1.ChildFormClose(Sender: TObject; var Action: TCloseAction);
begin
  if Assigned(FChildCloseEvent) then
    FChildCloseEvent(sender, Action);
  AdvToolBar1.RemoveMDIChildMenu(TForm(Sender));
  Action   := caFree;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FChildCount := 1;

end;

end.
